#pragma once
#include "Module.h"
#include <SDL.h>
#include <GL/glew.h>
#include <GL/GL.h>
#include <string>

namespace window {
	/*!
		Handles windowing.
	*/
	class WindowModule :
		public Module<WindowModule>
	{
	public:
		/*!
			Creates the window
		*/
		void start() final;
		void stop() final;
		SDL_Window * getSDLWindow();
		static WindowModule & getInstance() {
			static WindowModule module;
			return module;
		};
		int getWidth() {
			return m_width;
		}
		int getHeight() {
			return m_height;
		}
	private:
		typedef Module<WindowModule> super;
		SDL_GLContext m_context;
		SDL_Window * m_window;
		int m_width;
		int m_height;
	};

};
